package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.AppVersionService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "1-01 API版本信息接口", description = "用于获取api版本、提包相关")
@RequestMapping("/api/app")
@RestController
@RefreshScope
public class AppVersionController extends BaseController {

    private AppVersionService appVersionService;

    private BizConfigProperties bizConfigProperties;

    @Autowired
    public AppVersionController(AppVersionService appVersionService,
                                BizConfigProperties bizConfigProperties) {
        this.appVersionService = appVersionService;
        this.bizConfigProperties = bizConfigProperties;
    }

    @ApiOperation("1-1-1 获取当前操作系统的版本信息，用于提示用户是否需要升级app")
    @GetMapping(value = "/version")
    public Json<AppVersionDTO> getByMobileType(BasicParam basicParam) {

        return ResultUtil.genSuccessResult(this.appVersionService.getAppVersion(basicParam));
    }

    @ApiOperation("1-1-2 主要用于负载的心跳测试")
    @RequestMapping(value = "/getVersion", method = RequestMethod.GET)
    public Json version(HttpServletRequest request) {
        this.logger.info("request ip:" + WebUtils.getIpAddr(request) + ",local ip:" + WebUtils.getLocalRealIp());
        return ResultUtil.genSuccessMsg(bizConfigProperties.getTempDir());
    }

}
