package com.bxm.localnews.base.controller;


import com.bxm.localnews.base.service.AreaInfoService;
import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.dto.AreaDivisionDTO;
import com.bxm.localnews.common.dto.LocationMeta;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.AreaCode;
import com.bxm.localnews.common.vo.AreaInfo;
import com.bxm.localnews.common.vo.Json;
import com.sun.org.apache.bcel.internal.classfile.Code;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "1-04 地址基础服务接口", description = "地址基础服务接口")
@RequestMapping("/api/area")
@RestController
public class LocationController {

    private LocationService locationService;

    private AreaInfoService areaInfoService;

    @Autowired
    public LocationController(LocationService locationService,
                              AreaInfoService areaInfoService){
        this.locationService = locationService;
        this.areaInfoService = areaInfoService;
    }

    @GetMapping(value = "/division")
    @ApiOperation(value = "1-04-1 获得省份信息",notes = "获得全国省份信息")
    public Json<List< AreaDivisionDTO>> listAreaDivisionAdditional() {
        return ResultUtil.genSuccessResult(locationService.listAreaDivisionDTO(null));
    }


    @GetMapping(value = "/division/{parentCode}")
    @ApiOperation(value = "1-04-2 根据上级编码获取省市区县街道",notes = "如果pcode为空,则返回最上层的省份信息")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "path", name = "parentCode", value = "父级编号"),
    })
    public Json<List< AreaDivisionDTO>> listAreaDivision(@PathVariable String parentCode) {
        return ResultUtil.genSuccessResult(locationService.listAreaDivisionDTO(parentCode));
    }


    @GetMapping(value = "/location")
    @ApiOperation(value = "1-04-3 获取定位列表",notes = "包含开放的城市列表和热门城市列表,并根据首字母进行分组")
    public Json<LocationMeta> listAreaLocation() {
        return ResultUtil.genSuccessResult(locationService.listLocation());
    }

    @GetMapping(value = "/info/{code}")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "path", name = "code", value = "区域编号 一般为12位"),
    })
    @ApiOperation(value = "1-04-4 根据code获取区域的覆盖率和传播率",notes = "")
    public Json<AreaInfo> getAreaInfo(@PathVariable String code) {
        return ResultUtil.genSuccessResult(areaInfoService.getAreaInfo(code));
    }

}
