/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.AppVersionService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-01 API\u7248\u672c\u4fe1\u606f\u63a5\u53e3"}, description="\u7528\u4e8e\u83b7\u53d6api\u7248\u672c\u3001\u63d0\u5305\u76f8\u5173")
@RequestMapping(value={"/api/app"})
@RestController
@RefreshScope
public class AppVersionController
extends BaseController {
    private AppVersionService appVersionService;
    private BizConfigProperties bizConfigProperties;

    @Autowired
    public AppVersionController(AppVersionService appVersionService, BizConfigProperties bizConfigProperties) {
        this.appVersionService = appVersionService;
        this.bizConfigProperties = bizConfigProperties;
    }

    @ApiOperation(value="1-1-1 \u83b7\u53d6\u5f53\u524d\u64cd\u4f5c\u7cfb\u7edf\u7684\u7248\u672c\u4fe1\u606f\uff0c\u7528\u4e8e\u63d0\u793a\u7528\u6237\u662f\u5426\u9700\u8981\u5347\u7ea7app")
    @GetMapping(value={"/version"})
    public Json<AppVersionDTO> getByMobileType(BasicParam basicParam) {
        return ResultUtil.genSuccessResult((Object)this.appVersionService.getAppVersion(basicParam));
    }

    @ApiOperation(value="1-1-2 \u4e3b\u8981\u7528\u4e8e\u8d1f\u8f7d\u7684\u5fc3\u8df3\u6d4b\u8bd5")
    @RequestMapping(value={"/getVersion"}, method={RequestMethod.GET})
    public Json version(HttpServletRequest request) {
        this.logger.info("request ip:" + WebUtils.getIpAddr((HttpServletRequest)request) + ",local ip:" + WebUtils.getLocalRealIp());
        return ResultUtil.genSuccessMsg((String)this.bizConfigProperties.getTempDir());
    }
}

