/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.AreaInfoService;
import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.dto.AreaDivisionDTO;
import com.bxm.localnews.common.dto.LocationMeta;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.AreaInfo;
import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-04 \u5730\u5740\u57fa\u7840\u670d\u52a1\u63a5\u53e3"}, description="\u5730\u5740\u57fa\u7840\u670d\u52a1\u63a5\u53e3")
@RequestMapping(value={"/api/area"})
@RestController
public class LocationController {
    private LocationService locationService;
    private AreaInfoService areaInfoService;

    @Autowired
    public LocationController(LocationService locationService, AreaInfoService areaInfoService) {
        this.locationService = locationService;
        this.areaInfoService = areaInfoService;
    }

    @GetMapping(value={"/division"})
    @ApiOperation(value="1-04-1 \u83b7\u5f97\u7701\u4efd\u4fe1\u606f", notes="\u83b7\u5f97\u5168\u56fd\u7701\u4efd\u4fe1\u606f")
    public Json<List<AreaDivisionDTO>> listAreaDivisionAdditional() {
        return ResultUtil.genSuccessResult((Object)this.locationService.listAreaDivisionDTO(null));
    }

    @GetMapping(value={"/division/{parentCode}"})
    @ApiOperation(value="1-04-2 \u6839\u636e\u4e0a\u7ea7\u7f16\u7801\u83b7\u53d6\u7701\u5e02\u533a\u53bf\u8857\u9053", notes="\u5982\u679cpcode\u4e3a\u7a7a,\u5219\u8fd4\u56de\u6700\u4e0a\u5c42\u7684\u7701\u4efd\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="parentCode", value="\u7236\u7ea7\u7f16\u53f7")})
    public Json<List<AreaDivisionDTO>> listAreaDivision(@PathVariable String parentCode) {
        return ResultUtil.genSuccessResult((Object)this.locationService.listAreaDivisionDTO(parentCode));
    }

    @GetMapping(value={"/location"})
    @ApiOperation(value="1-04-3 \u83b7\u53d6\u5b9a\u4f4d\u5217\u8868", notes="\u5305\u542b\u5f00\u653e\u7684\u57ce\u5e02\u5217\u8868\u548c\u70ed\u95e8\u57ce\u5e02\u5217\u8868,\u5e76\u6839\u636e\u9996\u5b57\u6bcd\u8fdb\u884c\u5206\u7ec4")
    public Json<LocationMeta> listAreaLocation() {
        return ResultUtil.genSuccessResult((Object)this.locationService.listLocation());
    }

    @GetMapping(value={"/info/{code}"})
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="code", value="\u533a\u57df\u7f16\u53f7 \u4e00\u822c\u4e3a12\u4f4d")})
    @ApiOperation(value="1-04-4 \u6839\u636ecode\u83b7\u53d6\u533a\u57df\u7684\u8986\u76d6\u7387\u548c\u4f20\u64ad\u7387", notes="")
    public Json<AreaInfo> getAreaInfo(@PathVariable String code) {
        return ResultUtil.genSuccessResult((Object)this.areaInfoService.getAreaInfo(code));
    }
}

