/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.dto.ShortLinkMeta;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.ShortLinkReq;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-03 \u77ed\u94fe\u63a5\u63a5\u53e3"}, description="\u77ed\u94fe\u63a5\u8f6c\u6362\u4e0e\u8df3\u8f6c")
@RefreshScope
@RestController
@RequestMapping(value={"t"})
public class ShortLinkController {
    private ShortLinkService shortLinkService;
    private RedisStringAdapter redisStringAdapter;
    private BizConfigProperties bizConfigProperties;

    @Autowired
    public ShortLinkController(ShortLinkService shortLinkService, RedisStringAdapter redisStringAdapter, BizConfigProperties bizConfigProperties) {
        this.shortLinkService = shortLinkService;
        this.redisStringAdapter = redisStringAdapter;
        this.bizConfigProperties = bizConfigProperties;
    }

    @ApiOperation(value="1-03-1 \u83b7\u53d6\u77ed\u94fe\u63a5\u8df3\u8f6c\u5730\u5740\u5e76\u8f6c\u53d1")
    @ApiImplicitParam(name="key", value="\u77ed\u94fe\u63a5", required=true)
    @RequestMapping(value={"/{key}"}, method={RequestMethod.GET, RequestMethod.POST})
    public void getUrl(@PathVariable String key, HttpServletResponse resp) throws IOException {
        String url = (String)this.redisStringAdapter.get(RedisConfig.SHORT_URL.copy().appendKey((Object)key), String.class);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            resp.sendRedirect(url);
            return;
        }
        resp.sendRedirect(this.bizConfigProperties.getH5ServerHost() + "/register.html");
    }

    @ApiOperation(value="1-03-2 \u7ad9\u5185\u626b\u4e00\u626b\uff0c\u8df3H5\u62dc\u5e08")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u77ed\u94fe\u63a5", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @RequestMapping(value={"/{key}/{userId}"}, method={RequestMethod.GET, RequestMethod.POST})
    public void getUrl(@PathVariable String key, @PathVariable String userId, HttpServletResponse resp) throws IOException {
        String url = (String)this.redisStringAdapter.get(RedisConfig.SHORT_URL.copy().appendKey((Object)key), String.class);
        if (StringUtils.isNotEmpty((CharSequence)url) && StringUtils.isNotEmpty((CharSequence)userId)) {
            resp.sendRedirect(url + "&apprentice=" + userId);
        }
    }

    @ApiOperation(value="1-03-3 \u83b7\u53d6\u5bf9\u5e94\u7c7b\u578b\u7684\u77ed\u94fe\u63a5")
    @RequestMapping(value={"/getShortUrl"}, method={RequestMethod.GET, RequestMethod.POST})
    public Json<ShortLinkMeta> getRegisterShortURL(ShortLinkReq req) {
        ShortLinkMeta meta = new ShortLinkMeta();
        if (null == req.getType()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        if (1 == req.getType()) {
            meta.setSortUrl(this.shortLinkService.getRegisterShortUrl(req));
        } else if (2 == req.getType()) {
            meta.setSortUrl(this.shortLinkService.getDownloadShortUrl());
        } else if (3 == req.getType()) {
            meta.setSortUrl(this.shortLinkService.getFriendSweepShortUrl(req));
        } else {
            meta.setSortUrl(this.shortLinkService.getDownloadShortUrl());
        }
        return ResultUtil.genSuccessResult((Object)meta);
    }
}

