package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.AppVersionService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "1-01 API版本信息接口", description = "用于获取api版本、提包相关")
@RequestMapping("/api/app")
@RestController

public class AppVersionController extends BaseController {

    private AppVersionService appVersionService;

    private BizConfigProperties bizConfigProperties;

    @Autowired
    public AppVersionController(AppVersionService appVersionService, BizConfigProperties bizConfigProperties) {
        this.appVersionService = appVersionService;
        this.bizConfigProperties = bizConfigProperties;
    }

    @ApiOperation("1-1-1 获取当前操作系统的版本信息，用于提示用户是否需要升级app")
    @GetMapping(value = "/version")
    public Json<AppVersionDTO> getByMobileType(BasicParam basicParam, HttpServletRequest request) {
        String ip = WebUtils.getIpAddr(request);
        return ResultUtil.genSuccessResult(this.appVersionService.getAppVersion(basicParam, ip));
    }

    @ApiOperation("1-1-2 主要用于负载的心跳测试")
    @RequestMapping(value = {"/getVersion", "/heartbeat"}, method = RequestMethod.GET)
    public Json<String> version(HttpServletRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug("heart beat,request ip:" + WebUtils.getIpAddr(request));
        }
        return Json.build("ok");
    }

    @ApiOperation("1-1-3 测试请求超时")
    @RequestMapping("/test/timeout/{second}")
    @ResponseBody
    public String testTimeout(@PathVariable Float second) {

        logger.debug("request timeout:" + second);
        logger.debug("tempDir:" + bizConfigProperties.getTempDir());
        try {
            Thread.sleep((long) (second * 1000L));
        } catch (InterruptedException e) {
            logger.error(e.getMessage(), e);
        }
        return "response succed,sleep second:" + second;
    }
}
