package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.FeedbackService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Feedback;
import com.bxm.localnews.common.vo.Json;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author liujia 2018/7/31 15:52
 */
@Api(tags = "1-05 用户信息反馈接口", description = "用户提交使用反馈与建议")
@RequestMapping("/api")
@RestController
public class FeedbackController {

    private FeedbackService feedbackService;

    @Autowired
    public FeedbackController(FeedbackService feedbackService) {
        this.feedbackService = feedbackService;
    }

    @ApiOperation(value = "1-05-1 意见反馈", notes = "基础参数必传，需要进行签名验证")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "content", value = "内容", required = true)
    })
    @RequestMapping(value = "submit/feedback", method = RequestMethod.GET)
    public Json submitFeedback(@RequestParam(value = "userId") Long userId,
                               @RequestParam(value = "content") String content) {
        Feedback feedback = new Feedback(userId, content);
        this.feedbackService.insertSelective(feedback);
        return ResultUtil.genSuccessResult();
    }

}
