package com.bxm.localnews.base.facade.controller;

import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.common.vo.BasicParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-99 [内部接口]app版本验证")
@RestController
@RequestMapping("facade/app/version")
public class AppVersionFacadeController {

    @Autowired
    private AppVersionSupplyService appVersionSupplyService;

    @ApiOperation(value = "1-99-1 是否处于提包状态，true表示处于提包状态")
    @GetMapping("/state")
    public ResponseEntity<Boolean> isPublish(@RequestBody BasicParam basicParam) {
        return ResponseEntity.ok(appVersionSupplyService.getPublishState(basicParam));
    }

    @ApiOperation(value = "1-99-2 判断手机号码是否在白名单中，用于提包时的校验")
    @ApiImplicitParam(name = "phone", value = "手机号码", required = true)
    @GetMapping("/white")
    public ResponseEntity<Boolean> inWhiteList(@RequestParam("phone") String phone) {
        return ResponseEntity.ok(appVersionSupplyService.inWhiteList(phone));
    }

    @ApiOperation(value = "1-99-3 判断客户端版本是否高于服务端版本某个版本")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "curVer", value = "客户端版本", required = true),
            @ApiImplicitParam(name = "version", value = "服务端版本", required = true)
    })
    @GetMapping("/judge")
    public ResponseEntity<Integer> judgeCurVersion(@RequestParam String curVer, @RequestParam String version) {
        return ResponseEntity.ok(appVersionSupplyService.isHighVersion(curVer, version));
    }
}
