package com.bxm.localnews.base.facade.controller;

import com.bxm.localnews.base.service.EquipmentService;
import com.bxm.localnews.common.dto.EquipmentDTO;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-06 设备信息上报")
@RequestMapping("/facade/device")
@RestController
public class EquipmentFacadeController {

    @Autowired
    private EquipmentService equipmentService;

    @ApiOperation(value = "1-102-01 根据设备id得到设备信息", notes = "根据设备各种id（android的IMEI id uuid等）获得设备信息")
    @GetMapping(value = "/get/{id}")
    public ResponseEntity<EquipmentDTO> createTempUser(@PathVariable String id) {
        return ResponseEntity.ok(equipmentService.getByDeviceId(id));
    }
}
