/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.AreaInfoService;
import com.bxm.localnews.base.service.LocationRelationService;
import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.dto.AreaDivisionDTO;
import com.bxm.localnews.common.dto.CustomerServiceDTO;
import com.bxm.localnews.common.dto.LocationMeta;
import com.bxm.localnews.common.dto.LocationRelationDTO;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.AreaInfo;
import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-04 \u5730\u5740\u57fa\u7840\u670d\u52a1\u63a5\u53e3"}, description="\u5730\u5740\u57fa\u7840\u670d\u52a1\u63a5\u53e3")
@RequestMapping(value={"/api/area"})
@RestController
public class LocationController {
    private static final Logger LOG = LoggerFactory.getLogger(LocationController.class);
    private LocationService locationService;
    private AreaInfoService areaInfoService;
    private LocationRelationService locationRelationService;

    @Autowired
    public LocationController(LocationService locationService, AreaInfoService areaInfoService, LocationRelationService locationRelationService) {
        this.locationService = locationService;
        this.areaInfoService = areaInfoService;
        this.locationRelationService = locationRelationService;
    }

    @GetMapping(value={"/division"})
    @ApiOperation(value="1-04-1 \u83b7\u5f97\u7701\u4efd\u4fe1\u606f", notes="\u83b7\u5f97\u5168\u56fd\u7701\u4efd\u4fe1\u606f")
    public Json<List<AreaDivisionDTO>> listAreaDivisionAdditional() {
        return ResultUtil.genSuccessResult((Object)this.locationService.listAreaDivisionDTO(null));
    }

    @GetMapping(value={"/division/{parentCode}"})
    @ApiOperation(value="1-04-2 \u6839\u636e\u4e0a\u7ea7\u7f16\u7801\u83b7\u53d6\u7701\u5e02\u533a\u53bf\u8857\u9053", notes="\u5982\u679cpcode\u4e3a\u7a7a,\u5219\u8fd4\u56de\u6700\u4e0a\u5c42\u7684\u7701\u4efd\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="parentCode", value="\u7236\u7ea7\u7f16\u53f7", required=true)})
    public Json<List<AreaDivisionDTO>> listAreaDivision(@PathVariable String parentCode) {
        return ResultUtil.genSuccessResult((Object)this.locationService.listAreaDivisionDTO(parentCode));
    }

    @GetMapping(value={"/location"})
    @ApiOperation(value="1-04-3 \u83b7\u53d6\u5b9a\u4f4d\u5217\u8868", notes="\u5305\u542b\u5f00\u653e\u7684\u57ce\u5e02\u5217\u8868\u548c\u70ed\u95e8\u57ce\u5e02\u5217\u8868,\u5e76\u6839\u636e\u9996\u5b57\u6bcd\u8fdb\u884c\u5206\u7ec4")
    public Json<LocationMeta> listAreaLocation() {
        return ResultUtil.genSuccessResult((Object)this.locationService.listLocation());
    }

    @GetMapping(value={"/info/{code}"})
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="code", value="\u533a\u57df\u7f16\u53f7 \u4e00\u822c\u4e3a12\u4f4d", required=true)})
    @ApiOperation(value="1-04-4 \u6839\u636ecode\u83b7\u53d6\u533a\u57df\u4fe1\u606f", notes="")
    public Json<AreaInfo> getAreaInfo(@PathVariable String code) {
        return ResultUtil.genSuccessResult((Object)this.areaInfoService.getAreaInfo(code));
    }

    @GetMapping(value={"/speech"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u533a\u57df\u7f16\u53f7 \u4e00\u822c\u4e3a12\u4f4d"), @ApiImplicitParam(name="type", value="\u8bdd\u672f\u7c7b\u578b 1\uff1a\u5fae\u4fe1 2\uff1a\u670b\u53cb\u5708 5:\u5c0f\u7a0b\u5e8f\u5fae\u4fe1 6\uff1a\u5c0f\u7a0b\u5e8f\u670b\u53cb\u5708")})
    @ApiOperation(value="1-04-5 \u6839\u636ecode\u83b7\u53d6\u533a\u57df\u7684\u8bdd\u672f", notes="\u5728\u5206\u4eab\u81f3\u5fae\u4fe1\u7684\u65f6\u5019,\u9700\u8981\u663e\u793a\u7684\u6587\u5b57\uff1a\u5305\u62ec\u5fae\u4fe1\u3001\u670b\u53cb\u5708\u7684\u8bdd\u672f\uff0c\u5176\u4e2d\u5305\u542b\u5185\u5bb9\u548cID")
    public Json<LocationRelationDTO> getAreaSpeech(@RequestParam String code, @RequestParam Byte type) {
        LocationRelationDTO locationRelation = this.locationRelationService.getLocationRelation(code, type);
        return ResultUtil.genSuccessResult((Object)locationRelation);
    }

    @GetMapping(value={"/location/{code}/customer"})
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="code", value="\u533a\u57df\u7f16\u53f7 \u4e00\u822c\u4e3a12\u4f4d", required=true)})
    @ApiOperation(value="1-04-7 \u6839\u636e\u5730\u533acode\u83b7\u53d6\u5ba2\u670d\u4fe1\u606f", notes="\u83b7\u53d6\u5ba2\u670d\u4fe1\u606f-\u4e8c\u7ef4\u7801\u548c\u5fae\u4fe1\u53f7")
    public Json<CustomerServiceDTO> getCustomerServiceByCode(@PathVariable String code) {
        try {
            CustomerServiceDTO customerServiceDTO = this.locationService.getCustomerServiceInfo(code);
            if (null == customerServiceDTO) {
                return ResultUtil.genFailedResult((String)"\u83b7\u53d6\u5ba2\u670d\u4fe1\u606f\u5931\u8d25");
            }
            return ResultUtil.genSuccessResult((Object)customerServiceDTO);
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u5ba2\u670d\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ResultUtil.genFailedResult((String)"\u83b7\u53d6\u5ba2\u670d\u4fe1\u606f\u5f02\u5e38");
        }
    }
}

