/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.facade.controller;

import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-101 [\u5185\u90e8\u63a5\u53e3]\u83b7\u53d6\u4f4d\u7f6e\u4fe1\u606f"})
@RestController
@RequestMapping(value={"facade/location"})
public class LocationFacadeController {
    @Autowired
    private LocationService locationService;

    @ApiOperation(value="1-101-1 \u83b7\u53d6\u5b9a\u4f4d\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u5730\u533a\u7f16\u7801", required=true)})
    @GetMapping(value={"/info"})
    public ResponseEntity<LocationDetailDTO> getLocation(@RequestParam(value="code") String code) {
        return ResponseEntity.ok((Object)this.locationService.getInternalLocationByGeocode(code));
    }

    @ApiOperation(value="1-101-2 \u83b7\u53d6\u6240\u6709\u5df2\u5f00\u901a\u793e\u533a\u677f\u5757\u7684\u5730\u533a")
    @GetMapping(value={"/community/list"})
    public ResponseEntity<List<String>> listAllLocation() {
        return ResponseEntity.ok((Object)this.locationService.listAllLocationWithCommunity());
    }
}

