package com.bxm.localnews.base.controller;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.bxm.localnews.base.service.ClientConfigService;
import com.bxm.localnews.common.dto.MerchantCategoryDTO;
import com.bxm.localnews.common.param.DomainInfoParam;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;

import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/1/24 18:02
 * @desc
 */
@Api(tags = "1-02 客户端对应配置信息", description = "用于客户端获取对应配置信息")
@RequestMapping("/api/client/config")
@RestController
@AllArgsConstructor
public class ClientConfigController {

    private final ClientConfigService clientConfigService;


    @ApiOperation(value = "1-02-1 获取跳转页面的跳转类型", notes = "0：关闭 1:开启")
    @GetMapping(value = "/jump/type")
    public Json<Integer> getByMobileType() {
        return ResultUtil.genSuccessResult(this.clientConfigService.getJumpUrlType());
    }

    @ApiOperation(value = "1-02-2 根据key获取对应的value", notes = "")
    @GetMapping(value = "/key")
    public Json<String> getValueByKey(String key) {
        return ResultUtil.genSuccessResult(this.clientConfigService.getValueByKey(key));
    }

    @ApiOperation(value = "1-02-3 获取商家入驻类别", notes = "获取商家入驻类别:餐饮、电影、KTV等")
    @GetMapping(value = "/merchant/category/list")
    public Json<List<MerchantCategoryDTO>> listLabel() {
        return ResultUtil.genSuccessResult(this.clientConfigService.listMerchantCategory().stream().map(x -> new MerchantCategoryDTO(x, x)).collect(Collectors.toList()));
    }

    @ApiOperation(value = "1-02-4 获取客户端所有配置信息 key-value形式", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "platform", value = "平台类型", required = false)
    })
    @GetMapping("all")
    public Json<Map<String, String>> getAllConfig(@RequestParam(value = "platform", required = false) Integer platform) {
        return ResultUtil.genSuccessResult(this.clientConfigService.getAllConfig(platform));
    }

    @Deprecated
    @ApiOperation(value = "1-02-5 【已弃用】获取站外分享链接的base url", notes = "返回的url类型为 https://domain/baseUrl/ 然后与要分享的url拼接即可")
    @GetMapping("getBaseH5UrlByScene")
    public ResponseJson<String> getBaseH5UrlByScene(@RequestParam("scene") String scene) {
        DomainInfoParam param = new DomainInfoParam();
        param.setScene(scene);
        return ResponseJson.ok(clientConfigService.getBaseH5UrlByScene(param));
    }

    @ApiOperation(value = "1-02-6 根据场景获取base url 是1-02-5接口的新版本", notes = "返回的url类型为 https://domain/baseUrl/ 然后与要分享的url拼接即可")
    @GetMapping("getBaseH5UrlBySceneNew")
    public ResponseJson<String> getBaseH5UrlBySceneNew(DomainInfoParam param) {
        return ResponseJson.ok(clientConfigService.getBaseH5UrlByScene(param));
    }

}
