package com.bxm.localnews.base.facade.controller;

import com.bxm.localnews.common.config.ClientConfigProperties;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-103 获取配置信息")
@RequestMapping("/facade/clientConfig")
@RestController
@AllArgsConstructor(onConstructor = @__(@Autowired))
public class ClientConfigFacadeController {

    private final static String REPLY_SAY_HELLO_KEY = "replySayHello";

    private final ClientConfigProperties clientConfigProperties;

    @GetMapping("/getReplySayHello")
    public String  getReplySayHello(){
        return clientConfigProperties.getCommonKeys().get(REPLY_SAY_HELLO_KEY);
    }
}
