package com.bxm.localnews.base.facade.controller;

import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.dto.ShortLinkMeta;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-104 [内部接口]短链相关接口")
@RequestMapping("facade/shortLink")
@AllArgsConstructor
@RestController
public class ShortLinkFacadeController {

    private final ShortLinkService shortLinkService;

    @ApiOperation(value = "1-104-01 长链转短链", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "url", value = "长链接", required = true),
    })
    @GetMapping("generate")
    public ResponseEntity<ShortLinkMeta> generateShortUrl(@RequestParam("url") String url) {
        ShortLinkMeta meta = new ShortLinkMeta();
        meta.setSortUrl(shortLinkService.generateShortUrl(url));

        return ResponseEntity.ok(meta);
    }

}
