package com.bxm.localnews.common.config;

import com.google.common.collect.Lists;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 通用的业务配置，具体模块的配置需要在对应的模块内创建properties和特定的前缀接收
 * @author liujia 2018/7/26 16:45
 */
@Component
@ConfigurationProperties("common.config")
public class BizConfigProperties {

    /**
     * api签名加密密钥
     */
    private String apiSignKey;

    /**
     * 当前环节（遗留系统需要此值）
     */
    private int env;

    /**
     * 允许访问的请求来源，通过“,”分割
     */
    private String allowOrigins;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 临时文件存储目录
     */
    private String tempDir;

    /**
     * 是否启用方法签名
     */
    private Boolean enableRequestSign;

    /**
     * 后端API域名
     */
    private String serverHost;

    /**
     * h5访问根路径
     */
    private String h5ServerHost;

    /**
     * 应用图标地址
     */
    private String appIconUrl;

    /**
     * 推广渠道链接H5地址
     */
    private String channelUrl;

    /**
     * APP下载H5地址
     */
    private String downloadUrl;

    /**
     * 应用宝下载跳转地址
     */
    private String downloadYYBUrl;

    /**
     * 好友扫一扫链接地址
     */
    private String friendSweepUrl;

    /**
     * 白名单账号（用于app提包时提供的特殊账号）
     */
    private List<String> whiteList = Lists.newArrayList();

    /**
     * 安卓限制展示渠道列表(不同的渠道需要过包时进行敏感功能隐藏)
     */
    private List<String> disableAndroidChannel = Lists.newArrayList();

    /**
     * 是否开启上线检查开关（1：提包状态（敏感信息隐藏）,2:正常显示）
     */
    private String switchType;

    /**
     * 安卓拉新活动的apk下载包，apk文件路径.如果需要更新下载包，请保证下载包的名称有变化
     * 同名包只会下载一次
     */
    private String inviteAndriodApkUrl;

    /**
     * 区域编码
     */
    private String locationCode;

    /**
     * 区域名称
     */
    private String locationName;

    /**
     * 活动分享链接
     */
    private String privilegeShareUrl;

    /**
     * 业务打点日志的请求路径
     */
    private String bizLogUrl;

    /**
     * 客服微信号
     */
    private String customerServiceNumber;

    /**
     * 微信访问token
     */
    private String weixinAccessToken;

    /**
     * 日志埋点版本号，跟随客户端主版本号迭代
     */
    private String pointVersion = "2.5.0";

    public String getPointVersion() {
        return pointVersion;
    }

    public void setPointVersion(String pointVersion) {
        this.pointVersion = pointVersion;
    }

    public String getWeixinAccessToken() {
        return weixinAccessToken;
    }

    public void setWeixinAccessToken(String weixinAccessToken) {
        this.weixinAccessToken = weixinAccessToken;
    }

    public String getDownloadYYBUrl() {
        return downloadYYBUrl;
    }

    public void setDownloadYYBUrl(String downloadYYBUrl) {
        this.downloadYYBUrl = downloadYYBUrl;
    }

    public String getBizLogUrl() {
        return bizLogUrl;
    }

    public void setBizLogUrl(String bizLogUrl) {
        this.bizLogUrl = bizLogUrl;
    }

    public String getPrivilegeShareUrl() {
        return privilegeShareUrl;
    }

    public void setPrivilegeShareUrl(String privilegeShareUrl) {
        this.privilegeShareUrl = privilegeShareUrl;
    }

    public String getLocationCode() {
        return locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public String getLocationName() {
        return locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getInviteAndriodApkUrl() {
        return inviteAndriodApkUrl;
    }

    public void setInviteAndriodApkUrl(String inviteAndriodApkUrl) {
        this.inviteAndriodApkUrl = inviteAndriodApkUrl;
    }

    public String getSwitchType() {
        return switchType;
    }

    public void setSwitchType(String switchType) {
        this.switchType = switchType;
    }

    public List<String> getDisableAndroidChannel() {
        return disableAndroidChannel;
    }

    public void setDisableAndroidChannel(List<String> disableAndroidChannel) {
        this.disableAndroidChannel = disableAndroidChannel;
    }

    public List<String> getWhiteList() {
        return whiteList;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public String getChannelUrl() {
        return channelUrl;
    }

    public void setChannelUrl(String channelUrl) {
        this.channelUrl = channelUrl;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getFriendSweepUrl() {
        return friendSweepUrl;
    }

    public void setFriendSweepUrl(String friendSweepUrl) {
        this.friendSweepUrl = friendSweepUrl;
    }

    public String getServerHost() {
        return serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public String getH5ServerHost() {
        return h5ServerHost;
    }

    public void setH5ServerHost(String h5ServerHost) {
        this.h5ServerHost = h5ServerHost;
    }

    public String getAppIconUrl() {
        return appIconUrl;
    }

    public void setAppIconUrl(String appIconUrl) {
        this.appIconUrl = appIconUrl;
    }

    public Boolean getEnableRequestSign() {
        return this.enableRequestSign;
    }

    public void setEnableRequestSign(Boolean enableRequestSign) {
        this.enableRequestSign = enableRequestSign;
    }

    public String getTempDir() {
        if (null == this.tempDir) {
            this.tempDir = "/opt/tmp/";
        } else if (!this.tempDir.endsWith("/")) {
            this.tempDir = tempDir + "/";
        }
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public int getEnv() {
        return this.env;
    }

    public void setEnv(int env) {
        this.env = env;
    }

    public String getAllowOrigins() {
        return this.allowOrigins;
    }

    public void setAllowOrigins(String allowOrigins) {
        this.allowOrigins = allowOrigins;
    }

    public String getApiSignKey() {
        return this.apiSignKey;
    }

    public void setApiSignKey(String apiSignKey) {
        this.apiSignKey = apiSignKey;
    }

    public String getCustomerServiceNumber() {
        return customerServiceNumber;
    }

    public void setCustomerServiceNumber(String customerServiceNumber) {
        this.customerServiceNumber = customerServiceNumber;
    }


}
