package com.bxm.localnews.common.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@ConfigurationProperties("news.config")
public class NewsProperties {

    /**
     * 推荐栏目
     */
    private int recommendKindId;

    /**
     * 全民微课堂
     */
    private int knowledgeKindId;

    /**
     * 小视频
     */
    private int videoKindId;

    /**
     * 专门为IOS提包设置的默认频道
     */
    private List<Integer> propertyKindIds;

    /**
     * 阅读文章奖励次数
     */
    private int readNumAwardCount;

    /**
     * 阅读新闻奖励的时间差(防止连续阅读奖励)
     */
    private String awardTimeLag;

    /**
     * 给与金币的奖励条件（是否阅读到文章底部,1:否，2：是）
     */
    private String readBottom;

    /**
     * 给与金币的奖励条件（是否必须展示广告位1:否，2：是）
     */
    private String showAdvert;

    /**
     * 给与金币的奖励条件（是否达到最低的阅读时间）
     */
    private int viewTime;

    private String tabType;

    private int shareNumAwardCount;
    /**
     * 获得的金币上限
     */
    private int goldPerDay;

    public int getGoldPerDay() {
        return goldPerDay;
    }

    public void setGoldPerDay(int goldPerDay) {
        this.goldPerDay = goldPerDay;
    }

    public List<Integer> getPropertyKindIds() {
        return propertyKindIds;
    }

    public void setPropertyKindIds(List<Integer> propertyKindIds) {
        this.propertyKindIds = propertyKindIds;
    }

    public int getViewTime() {
        return viewTime;
    }

    public void setViewTime(int viewTime) {
        this.viewTime = viewTime;
    }

    public String getReadBottom() {
        return readBottom;
    }

    public void setReadBottom(String readBottom) {
        this.readBottom = readBottom;
    }

    public String getShowAdvert() {
        return showAdvert;
    }

    public void setShowAdvert(String showAdvert) {
        this.showAdvert = showAdvert;
    }

    public String getAwardTimeLag() {
        return awardTimeLag;
    }

    public void setAwardTimeLag(String awardTimeLag) {
        this.awardTimeLag = awardTimeLag;
    }

    public int getReadNumAwardCount() {
        return readNumAwardCount;
    }

    public void setReadNumAwardCount(int readNumAwardCount) {
        this.readNumAwardCount = readNumAwardCount;
    }

    public int getRecommendKindId() {
        return recommendKindId;
    }

    public void setRecommendKindId(int recommendKindId) {
        this.recommendKindId = recommendKindId;
    }

    public int getKnowledgeKindId() {
        return knowledgeKindId;
    }

    public void setKnowledgeKindId(int knowledgeKindId) {
        this.knowledgeKindId = knowledgeKindId;
    }

    public int getVideoKindId() {
        return videoKindId;
    }

    public void setVideoKindId(int videoKindId) {
        this.videoKindId = videoKindId;
    }

    public String getTabType() {
        return tabType;
    }

    public void setTabType(String tabType) {
        this.tabType = tabType;
    }

    public int getShareNumAwardCount() {
        return shareNumAwardCount;
    }

    public void setShareNumAwardCount(int shareNumAwardCount) {
        this.shareNumAwardCount = shareNumAwardCount;
    }
}
