package com.bxm.localnews.common.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块} 业务类型： biz:业务 config:配置
 */
public class RedisConfig {

    /**
     * ====================================================================== activity 模块相关缓存键值 用户日常任务完成状态
     */

    /**
     * 用户分享图片缓存路径
     */
    public static KeyGenerator USER_SHARE_IMAGES = DefaultKeyGenerator.build("activity", "share",
            "userimg");

    /**
     * 签到配置信息
     */
    public static KeyGenerator SIGN_CONFIG_KEY = DefaultKeyGenerator.build("activity", "sign_config");

    /**
     * 签到配置信息
     */
    public static KeyGenerator SIGN_CACHE_KEY = DefaultKeyGenerator.build("activity", "sign");

    /**
     * 用户签到总数缓存key
     */
    public static KeyGenerator SIGN_COUNT_KEY = DefaultKeyGenerator.build("activity", "sign");

    /**
     * 用户签到列表缓存key
     */
    public static KeyGenerator SIGN_LIST_KEY = DefaultKeyGenerator.build("activity", "signlist");

    /**
     * 用户签到排行榜
     */
    public static KeyGenerator SIGN_RANKING_KEY = DefaultKeyGenerator.build("activity", "sign", "ranking");

    /**
     * 用户签到通知消息
     */
    public static KeyGenerator SIGN_NOTIFICATION_KEY = DefaultKeyGenerator.build("activity", "sign", "notification");

    /**
     * 投票插件基础信息
     */
    public static KeyGenerator VOTE_INFO_KEY = DefaultKeyGenerator.build("activity", "vote", "info");

    /**
     * 投票插件各选项投票结果
     */
    public static KeyGenerator VOTE_OPTIONS_KEY = DefaultKeyGenerator.build("activity", "vote", "option");

    /**
     * 用户最后的投票选项记录
     */
    public static KeyGenerator LAST_VOTE_KEY = DefaultKeyGenerator.build("activity", "vote", "last");

    /**
     * 用户投票相关缓存KEY
     */
    public static KeyGenerator USER_VOTE_KEY = DefaultKeyGenerator.build("activity", "vote", "user");

    /**
     * 内容引导弹窗提醒
     */
    public static KeyGenerator CONTENT_GUIDE_KEY = DefaultKeyGenerator.build("activity", "content", "guide");

    /**
     * ============ 任务 ================
     */
    /**
     * 任务列表及其状态
     */
    public static KeyGenerator DAILY_TASK_COMPELE_STATUS = DefaultKeyGenerator.build("activity",
            "taskcompelestate");

    /**
     * 用户当天完成任务获得奖励金币总数, 有效期:当天
     */
    public static KeyGenerator USER_MISSION_REWARD_SUM_PER_DAY = DefaultKeyGenerator.build("activity", "task",
            "sumreward");

    /**
     * 当日分享新闻次数 ,有效期:当天
     */
    public static KeyGenerator TASK_SHARE_NEWS_NUM = DefaultKeyGenerator.build("activity", "task",
            "sharenews");

    /**
     * 用户阅读新闻获得奖励的次数
     */
    public static KeyGenerator NEWS_READ = DefaultKeyGenerator.build("news", "readnews");

    /**
     * 用户阅读视频获得奖励的次数
     */
    public static KeyGenerator VIDEO_READ_NUM = DefaultKeyGenerator.build("activity", "task",
            "readvideo");

    /**
     * 用户每日发帖数量
     */
    public static KeyGenerator POST_FORUM = DefaultKeyGenerator.build("activity", "task", "postforum");

    /**
     * 用户签到转发次数
     */
    public static KeyGenerator SIGN_SHARE_NUM = DefaultKeyGenerator.build("activity", "sign", "share");

    /**
     * 用户是否签到转发
     */
    public static KeyGenerator IS_SIGN_SHARE = DefaultKeyGenerator.build("activity", "sign", "isshare");

    /**
     * 新闻评论
     */
    public static KeyGenerator NEWS_COMMENT = DefaultKeyGenerator.build("activity", "task", "newscomment");

    /**
     * 每日首次分享新闻/帖子
     */
    public static KeyGenerator NEWS_SHARE = DefaultKeyGenerator.build("activity", "task", "newsshare");

    /**
     * 任务分布式锁键值
     */
    public static KeyGenerator ACTIVITY_LOCK = DefaultKeyGenerator.build("activity", "task");

    /**
     * ================= vip ==============
     */
    /**
     * 用户vip卡编码生成记录
     */
    public static KeyGenerator USER_VIP_NUM_RECORD = DefaultKeyGenerator.build("activity", "user_vip",
            "num");

    /**
     * 用户已激活vip信息(昵称)
     */
    public static KeyGenerator USER_VIP_RANK = DefaultKeyGenerator.build("activity", "user_vip",
            "rank");

    /**
     * 用户已激活vip信息(头像)
     */
    public static KeyGenerator USER_VIP_RANK_IMG = DefaultKeyGenerator.build("activity", "user_vip",
            "rank_img");

    /**
     * 用户领取vip时的过期时间戳 有效期：半个小时
     */
    public static KeyGenerator USER_RECEIVE_VIP_TIME = DefaultKeyGenerator.build("activity",
            "vip_valid_time");

    /**
     * 用户显示浮层24小时后的时间戳 有效期：24小时
     */
    public static KeyGenerator USER_LAYER_EXPIRE_TIME = DefaultKeyGenerator.build("activity",
            "vip_layer_time");

    /**
     * 用户是否显示浮层
     */
    public static KeyGenerator USER_SHOW_LAYER = DefaultKeyGenerator.build("activity",
            "user_show_layer");
    /**
     *  ==================== 口令红包 ===============
     */
    /**
     * 口令红包已参与分享话术对应的自增值
     */
    public static KeyGenerator RED_PACKET_SHARE_INVOLVED = DefaultKeyGenerator.build("activity", "red_packet", "share_involved");

    /**
     * 口令红包未参与分享话术对应的自增值
     */
    public static KeyGenerator RED_PACKET_SHARE_UNINVOLVED = DefaultKeyGenerator.build("activity", "red_packet", "share_uninvolved");

    /**
     * ================ 活动 ===============
     */
    /**
     * 活动邀请人数排行榜缓存
     */
    public static KeyGenerator PRIVILEGE_INVITENUM = DefaultKeyGenerator.build("activity", "privilege_invitenum");

    /**
     * 活动列表缓存
     */
    public static KeyGenerator PRIVILEGE_lIST = DefaultKeyGenerator.build("activity", "privilege_list");

    /**
     * ====================================================================== user 模块相关缓存键值 用户信息
     */

    /**
     * 用户信息缓存
     */
    public static KeyGenerator USER_INFO = DefaultKeyGenerator.build("user", "cache", "userInfo");

    /**
     * 用户等级配置
     */
    public static KeyGenerator USER_LEVEL_CONFIG = DefaultKeyGenerator.build("user", "user", "level");

    /**
     * 微信同步时效
     */
    public static KeyGenerator WEIXIN_SYS_LIMIT = DefaultKeyGenerator.build("user", "sync",
            "weixin_sys_limit");

    /**
     * ====================================================================== thirdparty 模块相关缓存键值 短链接key
     */
    public static KeyGenerator SHORT_URL = DefaultKeyGenerator.build("thirdparty", "cache",
            "short_url");

    /**
     * 机器扫描短链接
     */
    public static KeyGenerator MACHINE_SHORT_URL_KEY = DefaultKeyGenerator.build("thirdparty", "machine");

    /**
     * 机器扫描总次数
     */
    public static KeyGenerator MACHINE_SCAN_COUNT = DefaultKeyGenerator.build("thirdparty",
            "machineScanCount");

    /**
     * 积分商城列表
     */
    public static KeyGenerator POINTS_MALL_KEY = DefaultKeyGenerator.build("thirdparty", "pointsMall");

    /**
     * 天气（半个小时刷新一次）
     */
    public static KeyGenerator THIRDPARTY_WEATHER = DefaultKeyGenerator.build("thirdparty", "weather");

    /**
     * 天气（未来7天的天气预报信息）
     */
    public static KeyGenerator THIRDPARTY_FUTURE_WEATHER = DefaultKeyGenerator.build("thirdparty", "future_weather");

    /**
     * 万年历（当天的黄历三天时间过期）
     */
    public static KeyGenerator THIRDPARTY_CALENDAR = DefaultKeyGenerator.build("thirdparty", "calendar");

    /**
     * 工具类列表(7天过期)
     */
    public static KeyGenerator THIRDPARTY_AREACODE_TOOLS = DefaultKeyGenerator.build("thirdparty",
            "areacode_tools");

    /**
     * 广告类列表
     */
    public static KeyGenerator THIRDPARTY_TYPE_ADVERT = DefaultKeyGenerator.build("thirdparty", "advert");

    /**
     * 广告展示方式
     */
    public static KeyGenerator THIRDPARTY_SHOW_TYPE_ADVERT = DefaultKeyGenerator.build("thirdparty", "advert");

    /**
     * 蓝领招聘
     */
    public static KeyGenerator THIRDPARTY_RECRUIT = DefaultKeyGenerator.build("thirdparty", "recruit");

    /**
     * 吃喝玩乐
     */
    public static KeyGenerator THIRDPARTY_ENJOY_EAT = DefaultKeyGenerator.build("thirdparty", "enjoy_eat");

    /**
     * 微信相关key的存放
     */
    public static KeyGenerator WEIXIN_KEY = DefaultKeyGenerator.build("thirdparty", "weixin");


    /**
     * 微信formId缓存 过期时间：24小时
     */
    public static KeyGenerator WEIXIN_FORMID = DefaultKeyGenerator.build("thirdparty", "weixin_formId");

    public static KeyGenerator WX_APPLET_POPUP = DefaultKeyGenerator.build("thirdparty", "wx_applet");

    /**
     * 广告等待回调的地址，5个小时候过期
     */
    public static KeyGenerator AD_CALLBACK = DefaultKeyGenerator.build("thirdpart", "cache", "callback");

    /**
     * 用户弹窗缓存
     */
    public static KeyGenerator USER_CACHE_POPUP = DefaultKeyGenerator.build("thirdparty", "pop", "cache");
    /**
     * ================= base模块 =====================
     */

    /**
     * channel 所有渠道版本信息
     */
    public static KeyGenerator BASE_APPVERSION_CHANNEL = DefaultKeyGenerator.build("base",
            "appversion_channel");

    /**
     * 数据字典缓存
     */
    public static KeyGenerator DICT_CACHE = DefaultKeyGenerator.build("base", "cache", "dict");

    /**
     * ip 存放美国ip的提包状态（设置为true）
     */
    public static KeyGenerator BASE_IP = DefaultKeyGenerator.build("base", "ip");

    /**
     * channel 所有渠道信息
     */
    public static KeyGenerator BASE_CHANNEL = DefaultKeyGenerator.build("base", "channel");

    /**
     * 热门城市信息
     */
    public static KeyGenerator HOT_LOCATION = DefaultKeyGenerator.build("base", "location", "hot");

    /**
     * 定位城市信息
     */
    public static KeyGenerator OPENED_LOCATION = DefaultKeyGenerator.build("base", "location",
            "opened");

    /**
     * 客服信息
     */
    public static KeyGenerator CUSTOMER_SERVICE_INFO = DefaultKeyGenerator.build("base", "location", "customer_service_info");


    /**
     * 区域信息
     */
    public static KeyGenerator AREA_INFO = DefaultKeyGenerator.build("base", "area", "info");

    /**
     * 地区编码和名称的映射缓存
     */
    public static KeyGenerator AREA_INFO_MAP = DefaultKeyGenerator.build("base", "area", "map");

    /**
     * 微信分享话术对应的自增值
     */
    public static KeyGenerator WEIXIN_LOCATION_RELATION = DefaultKeyGenerator.build("base", "location_relation", "weixin");

    /**
     * 微信朋友圈分享话术对应的自增值
     */
    public static KeyGenerator WEIXIN_FRIEND_LOCATION_RELATION = DefaultKeyGenerator.build("base", "location_relation", "wx_friend");

    /**
     * 微信小程序分享话术对应的自增值
     */
    public static KeyGenerator WEIXIN_APPLET_LOCATION_RELATION = DefaultKeyGenerator.build("base", "location_relation", "weixin_applet");

    /**
     * 微信朋友圈分享话术对应的自增值
     */
    public static KeyGenerator WEIXIN_APPLET_FRIEND_LOCATION_RELATION = DefaultKeyGenerator.build("base", "location_relation", "wx_friend_applet");

    /**
     * 微信是否取固定地区的自增值
     */
    public static KeyGenerator WEIXIN_SHARE_FIXED_AREACODE = DefaultKeyGenerator.build("base", "location_relation", "share_code");

    /**
     * ========================= payment 模块相关缓存信息 ================================
     */

    /**
     * 微信订单状态缓存 过期时间：24小时
     */
    public static KeyGenerator WEIXIN_ORDER_STATUS = DefaultKeyGenerator.build("payment", "weixin_order");

    public static KeyGenerator USER_WITHDRAW = DefaultKeyGenerator.build("payment", "user_withdraw");

    /**
     * 公司账户余额
     */
    public static KeyGenerator COMPANY_REMAIN_AMOUNT = DefaultKeyGenerator.build("payment", "company_remain_amount");

    /**
     * 小程序提现金额累计
     */
    public static KeyGenerator WEIXIN_MINI_APP_AMOUNT = DefaultKeyGenerator.build("payment", "wx_mini_app_amount");

    /**
     * 蓝天救援队已助力次数
     */
    public static KeyGenerator BLUE_SKY_HELPED_NUM = DefaultKeyGenerator.build("activity", "blue_sky", "helped_num");

    /**
     * 蓝天救援队是否已助力完成
     */
    public static KeyGenerator BLUE_SKY_HELP_COMPLETE = DefaultKeyGenerator.build("activity", "blue_sky", "help_complete");

    /**
     * 蓝天救援队助力发帖
     */
    public static KeyGenerator BLUE_SKY_CREATE_POST = DefaultKeyGenerator.build("activity", "blue_sky_create_post");

    /**
     * 蓝天救援队弹窗
     */
    public static KeyGenerator BLUE_SKY_HOME_WINDOW = DefaultKeyGenerator.build("activity", "blue_sky_home_window");

    /**
     * 蓝天救援队H5弹窗
     */
    public static KeyGenerator BLUE_SKY_H5_HOME_WINDOW = DefaultKeyGenerator.build("activity", "blue_sky_h5_home_window");

    /**
     * 地区黑白名单列表
     */
    public static KeyGenerator AREA_WHITE_BLACK_LIST = DefaultKeyGenerator.build("base", "area_white_black_list");


}
