package com.bxm.localnews.base.service;

import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.param.GetAvailableDomainInfoParam;
import com.bxm.localnews.common.param.GetViewSceneDomainInfoParam;
import com.bxm.localnews.common.vo.BaseUrlInfo;
import com.bxm.localnews.common.vo.ViewSceneBaseUrl;

/**
 * 域名内部服务 提供了一些大众场景的base url获取
 * 保证了返回的base url 如果是h5地址的base url则以/h5/ 结尾
 * 但是如短链、服务器地址等等这些信息则不会拼接（毕竟是服务器地址嘛）
 * @author gonzo
 * @date 2020-07-30 16:21
 **/
public interface BaseUrlFacadeService {

    /**
     * 根据请求参数，获取可用的base url信息
     * @param param 包含场景、基础参数的请求参数
     * @return 包含了域名、baseUrl（如果有需要则会拼接）的信息
     */
    BaseUrlInfo getBaseUrlInfo(GetAvailableDomainInfoParam param);

    /**
     * 根据请求参数，获取具体落地页的base url信息
     * @param param 包含了落地页场景的参数
     * @return 落地页的域名信息
     */
    ViewSceneBaseUrl getViewSceneBaseUrl(GetViewSceneDomainInfoParam param);

    /**
     * 获取短链的base url
     * @return 短链的base url
     */
    String getShortLinkBaseUrl();

    /**
     * 获取内部H5 base url
     * @return 内部H5 base url
     */
    String getInnerH5BaseUrl();

    /**
     * 获取分享的base url
     * @param viewScene  分享落地页的场景 需要进行拼接的
     * @return 分享的base url
     */
    String getOutSideShareBaseUrl(DomainScene.DomainViewScene viewScene);

    /**
     * 获取应用宝下载地址
     * @return 应用宝下载地址
     */
    String getDownloadYYBUrl();

    /**
     * 获取appIcon地址
     * @return appIcon地址
     */
    String getAppIconUrl();

    /**
     * 获取落地页场景类型为内容的base url
     * @return 落地页类型为内容的base url
     */
    String getContentViewSceneBaseUrl();

    /**
     * 获取下载地址页面
     * 非应用宝下载地址
     * @return 下载地址页面
     */
    String getDownloadUrl();

    /**
     * 获取服务器的base url
     * @return 服务器的base url
     */
    String getServerHostBaseUrl();
}
