package com.bxm.localnews.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

@ApiModel(description = "区域详情实体")
public class AreaInfo implements Serializable {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("区域编码")
    private String code;

    @ApiModelProperty("区域名称")
    private String name;

    @ApiModelProperty("常住人口")
    private String population;

    @ApiModelProperty("地区描述（文案性质的描述），支持html")
    private String description;

    @ApiModelProperty("覆盖率")
    private String coverRate;

    @ApiModelProperty("传播率")
    private String transmissionRate;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPopulation() {
        return population;
    }

    public void setPopulation(String population) {
        this.population = population;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCoverRate() {
        return coverRate;
    }

    public void setCoverRate(String coverRate) {
        this.coverRate = coverRate;
    }

    public String getTransmissionRate() {
        return transmissionRate;
    }

    public void setTransmissionRate(String transmissionRate) {
        this.transmissionRate = transmissionRate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}