package com.bxm.localnews.common.dto;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * c_location_relation
 *
 * @author
 */
@ApiModel(description = "微信话术返回实体")
public class LocationRelationDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("关联内容（微信分享语、朋友圈分享语）")
    private String content = "";

    @ApiModelProperty("类型（1、微信分享语，2：朋友圈分享语，3：微信图片 4：朋友圈图片  11:聊天室分享配置）")
    private Byte type;

    @ApiModelProperty("地区编号")
    private String locationCode;

    @ApiModelProperty("分享图片")
    private String imgUrl;

    @ApiModelProperty("分享描述")
    private String contentDescription;

    @ApiModelProperty("h5分享详情")
    private String webShareDes;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getLocationCode() {
        return locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getContentDescription() {
        return contentDescription;
    }

    public void setContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
    }

    public String getWebShareDes() {
        return webShareDes;
    }

    public void setWebShareDes(String webShareDes) {
        this.webShareDes = webShareDes;
    }
}