package com.bxm.localnews.common.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * t_base_domain_publish
 * @author
 */
@Data
public class AddDomainPublishParam {

    /**
     * 域名id
     */
    @NotNull(message = "请选择域名")
    private Long domainId;

    /**
     * 协议 http:// or https://
     */
    @NotBlank(message = "请选择协议")
    private String protocol;

    /**
     * 投放场景 0: 站内H5 1：站内淘宝授权 2: 短链 3: 站外分享域名 4: 站外分享落地页域名  5: 站外微信用户授权中间页 6: 站外微信支付中间页
     */
    @NotNull(message = "请选择投放场景")
    private Byte scene;

    /**
     * 如果域名场景是落地页域名 则该字段标识落地页场景 0: 非落地页域名 1: 站外内容落地页 2: 站外推广落地页 3: 站外活动落地页
     */
    private Byte viewScene;

    /**
     * 如果涉及到公众号授权，则当前域名绑定的公众号信息
     */
    private String appId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态 1可用 0不可用
     */
    private Byte status;

}