package com.bxm.localnews.common.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * t_base_domain
 * @author
 */
@Data
public class DomainVO implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 域名（不带协议）
     */
    private String domain;

    /**
     * 状态 0: 下架 1: 上架 2: 已被封
     */
    private Byte status;

    private String statusStr;

    private String remark;

    /**
     * 封禁（微信环境）时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date blockedTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
}