package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.LocationRelationMapper;
import com.bxm.localnews.base.service.LocationRelationService;
import com.bxm.localnews.common.dto.LocationRelationDTO;
import com.bxm.localnews.common.vo.LocationRelation;
import com.bxm.newidea.component.service.BaseService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;

@Service
public class LocationRelationServiceImpl extends BaseService implements LocationRelationService {

    @Autowired
    LocationRelationMapper locationRelationMapper;

    @Override
    public LocationRelationDTO getLocationRelation(String code,Byte type) {
        LocationRelation relation = new LocationRelation();
        relation.setLocationCode(code);
        relation.setType(type);
        List<LocationRelation> locationRelationList = locationRelationMapper.selectByModel(relation);
        if (CollectionUtils.isNotEmpty(locationRelationList)) {
            LocationRelation locationRelation = locationRelationList.stream().min(Comparator.comparing(LocationRelation::getShareTime)).get();
            locationRelation.setShareTime(locationRelation.getShareTime() + 1);
            locationRelationMapper.updateByPrimaryKey(locationRelation);
            return convertLocationRelation(locationRelation);
        }
        return new LocationRelationDTO();
    }

    /**
     * 对象转换
     * @param locationRelation
     * @return
     */
    private LocationRelationDTO convertLocationRelation(LocationRelation locationRelation){
        LocationRelationDTO locationRelationDTO = new LocationRelationDTO();
        locationRelationDTO.setContent(locationRelation.getContent());
        locationRelationDTO.setId(locationRelation.getId());
        locationRelationDTO.setLocationCode(locationRelation.getLocationCode());
        locationRelationDTO.setType(locationRelation.getType());
        return locationRelationDTO;
    }
}
