package com.bxm.localnews.base.vo;

import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

public class BizLogParamBuilder {

    private Map<String, String> result = Maps.newHashMap();

    private BizLogAsyncSaveService bizLogAsyncSaveService;

    private BizLogParamBuilder() {
    }

    public static BizLogParamBuilder build(String event, BizLogAsyncSaveService bizLogAsyncSaveService) {
        BizLogParamBuilder builder = new BizLogParamBuilder();
        builder.get().put("e", event);
        builder.get().put("p", "news");
        builder.get().put("v", "1.2.0");
        builder.get().put("dtype", "3");
        builder.get().put("ts", System.currentTimeMillis() + "");
        builder.setBizLogAsyncSaveService(bizLogAsyncSaveService);
        return builder;
    }

    public BizLogParamBuilder setUid(Long userId) {
        result.put("uid", convert(userId));
        return this;
    }

    public BizLogParamBuilder setActivityId(Long privilegeId) {
        result.put("activityid", convert(privilegeId));
        return this;
    }

    public BizLogParamBuilder setEventVal(Object val) {
        result.put("ev", convert(val));
        return this;
    }

    public BizLogParamBuilder setSrc(Long channel) {
        result.put("src", convert(channel));
        return this;
    }

    public BizLogParamBuilder setPageSource(String source) {
        result.put("page_src", convert(source));
        return this;
    }

    public BizLogParamBuilder setIsOnline(Integer isOnline) {
        result.put("is_online", convert(isOnline));
        return this;
    }

    public BizLogParamBuilder setIp(String ip) {
        result.put("ip", convert(ip));
        return this;
    }

    public BizLogParamBuilder setToken(String token) {
        result.put("token", convert(token));
        return this;
    }

    public BizLogParamBuilder setPageSrc(String pageSrc) {
        result.put("page_src", convert(pageSrc));
        return this;
    }

    public BizLogParamBuilder setOneline(int oneline) {
        result.put("is_online", convert(oneline));
        return this;
    }

    public BizLogParamBuilder setMid(String mid) {
        result.put("mid", convert(mid));
        return this;
    }

    private void setBizLogAsyncSaveService(BizLogAsyncSaveService bizLogAsyncSaveService) {
        this.bizLogAsyncSaveService = bizLogAsyncSaveService;
    }

    private String convert(Object obj) {
        if (null == obj) {
            return StringUtils.EMPTY;
        }
        return obj.toString();
    }

    private Map<String, String> get() {
        return result;
    }

    public void save() {
        this.bizLogAsyncSaveService.save(this.result);
    }

}