package com.bxm.localnews.base.service;

import com.bxm.localnews.base.dto.LocationDTO;
import com.bxm.localnews.common.dto.AreaDivisionDTO;
import com.bxm.localnews.common.dto.LocationMeta;
import com.bxm.localnews.common.vo.AreaCode;
import com.bxm.localnews.common.vo.Location;

import java.util.List;
import java.util.Map;

public interface LocationService {

    /**
     * 用途：获取对应地区的编码
     * @param name 地区
     * @param province 省市
     * @return 地区的编码
     */
    AreaCode selectByAreaName(String name, String province);

    /**
     * 用途：获取热门城市列表以及已开通城市列表
     * @return
     */
    LocationMeta listLocation();

    /**
     * 用途：根据父级编号获得省市区街道地址
     * @param parentCode
     * @return
     */
    List<AreaDivisionDTO> listAreaDivisionDTO(String parentCode);

    /**
     * 根据客户端传来的城市编码获得区县信息
     * 客户端传来的编号是通过高德api得到的，只有6位，需要对其进行补位，以12位的编码去查询
     * 如果查询不到，则去查找他的上一级
     * example：
     * 1."淳安县"：由于是县，直接在已开通城市中可以找到
     * 2."西湖区"：由于是区，需要在上一级(杭州)去查询
     *
     * @param code
     * @return
     */
    LocationDTO getInternalLocationByGeocode(String code);
}
