package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.config.ClientConfigProperties;
import com.bxm.localnews.base.service.ClientConfigService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zhaoyadong 2019/1/24 18:01
 * @desc
 */
@Service
@RefreshScope
public class ClientConfigServiceImpl implements ClientConfigService {

    @Autowired
    private ClientConfigProperties clientConfigProperties;

    @Override
    public Integer getJumpUrlType() {
        return clientConfigProperties.getJumpUrlType();
    }

    @Override
    public String getValueByKey(String key) {
        return clientConfigProperties.getKeys().get(key);
    }

    @Override
    public List<String> listMerchantCategory() {
        return clientConfigProperties.getMerchantCategory();
    }
}
