package com.bxm.localnews.base.service.impl;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class BizLogAsyncSaveServiceImpl extends BaseService implements BizLogAsyncSaveService {

    private HttpClientService httpClientService;

    private BizConfigProperties bizConfigProperties;

    @Autowired
    public BizLogAsyncSaveServiceImpl(HttpClientService httpClientService, BizConfigProperties bizConfigProperties) {
        this.httpClientService = httpClientService;
        this.bizConfigProperties = bizConfigProperties;
    }

    @Override
    @Async
    public void save(Map<String, String> data) {
        try {
            httpClientService.doGet(bizConfigProperties.getBizLogUrl(), data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }
}
