package com.bxm.localnews.base.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.bxm.localnews.base.config.ClientConfigProperties;
import com.bxm.localnews.base.service.ClientConfigService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/1/24 18:01
 * @desc
 */
@Service

public class ClientConfigServiceImpl implements ClientConfigService {

    @Autowired
    private ClientConfigProperties clientConfigProperties;

    @Override
    public Integer getJumpUrlType() {
        return clientConfigProperties.getJumpUrlType();
    }

    @Override
    public String getValueByKey(String key) {
        return clientConfigProperties.getKeys().get(key);
    }

    @Override
    public List<String> listMerchantCategory() {
        return clientConfigProperties.getMerchantCategory();
    }

    @Override
    public Map<String, String> getAllConfig(Integer platform) {
        Map<String, String> commonMap;
        commonMap = clientConfigProperties.getCommonKeys();

        Map<String, String> specialMap;
        if (platform == 1) {
            specialMap = clientConfigProperties.getAndroidKeys();
        } else if (platform == 2) {
            specialMap = clientConfigProperties.getIosKeys();
        } else if (platform == 3) {
            specialMap = clientConfigProperties.getWebKeys();
        } else if (platform == 5) {
            specialMap = clientConfigProperties.getAppletKeys();
        } else {
            specialMap = clientConfigProperties.getKeys();
        }
        Map<String, String> resultMap = new HashMap<>(commonMap);
        resultMap.putAll(specialMap);
        return resultMap;
    }
}
