package com.bxm.localnews.base.vo;

import java.math.BigDecimal;
import java.util.Map;

import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.google.common.collect.Maps;

import org.apache.commons.lang3.StringUtils;

public class BizLogParamBuilder {

    private Map<String, String> result = Maps.newHashMap();

    private BizLogAsyncSaveService bizLogAsyncSaveService;

    private BizLogParamBuilder() {
    }

    public static BizLogParamBuilder build(String event, BizLogAsyncSaveService bizLogAsyncSaveService) {
        BizLogParamBuilder builder = new BizLogParamBuilder();
        builder.get().put("e", event);
        builder.get().put("p", "news");
        builder.get().put("v", "2.4.0");
        builder.get().put("dtype", "3");
        builder.get().put("ts", System.currentTimeMillis() + "");
        builder.setBizLogAsyncSaveService(bizLogAsyncSaveService);
        return builder;
    }

    public static BizLogParamBuilder build(String event, String areaCode,
                                           BizLogAsyncSaveService bizLogAsyncSaveService) {
        return build(event, bizLogAsyncSaveService).setAreaCode(areaCode);
    }

    public BizLogParamBuilder setUid(Long userId) {
        result.put("uid", convert(userId));
        return this;
    }

    public BizLogParamBuilder setActivityId(Long privilegeId) {
        result.put("activityid", convert(privilegeId));
        return this;
    }

    public BizLogParamBuilder setEventVal(Object val) {
        result.put("ev", convert(val));
        return this;
    }

    public BizLogParamBuilder setSrc(Long channel) {
        result.put("src", convert(channel));
        return this;
    }

    public BizLogParamBuilder setPageSource(String source) {
        result.put("page_src", convert(source));
        return this;
    }

    public BizLogParamBuilder setIsOnline(Integer isOnline) {
        result.put("is_online", convert(isOnline));
        return this;
    }

    public BizLogParamBuilder setIp(String ip) {
        result.put("ip", convert(ip));
        return this;
    }

    public BizLogParamBuilder setToken(String token) {
        result.put("token", convert(token));
        return this;
    }

    public BizLogParamBuilder setPageSrc(String pageSrc) {
        result.put("page_src", convert(pageSrc));
        return this;
    }

    public BizLogParamBuilder setOneline(int oneline) {
        result.put("is_online", convert(oneline));
        return this;
    }

    public BizLogParamBuilder setMid(String mid) {
        result.put("mid", convert(mid));
        return this;
    }

    public BizLogParamBuilder setAreaCode(String areaCode) {
        result.put("a", convert(areaCode));
        return this;
    }

    public BizLogParamBuilder setNum(Integer num) {
        result.put("num", num.toString());
        return this;
    }

    public BizLogParamBuilder setMoney(BigDecimal money) {
        result.put("money", money.toString());
        return this;
    }

    /**
     * 设置帖子或者新闻、小视频id
     *
     * @param nid 帖子或者新闻、小视频id
     * @return 返回结果
     */
    public BizLogParamBuilder setNid(Long nid) {
        result.put("nid", convert(nid));
        return this;
    }

    /**
     * 设置内容类型
     *
     * @param type 内容类型
     * @return 返回结果
     */
    public BizLogParamBuilder setNType(Integer type) {
        result.put("n_type", convert(type));
        return this;
    }

    public BizLogParamBuilder setRid(String rid) {
        result.put("rid", convert(rid));
        return this;
    }

    public BizLogParamBuilder setDtype(Integer dtype) {
        if (null != dtype) {
            result.put("dtype", dtype.toString());
        }
        return this;
    }

    private void setBizLogAsyncSaveService(BizLogAsyncSaveService bizLogAsyncSaveService) {
        this.bizLogAsyncSaveService = bizLogAsyncSaveService;
    }

    private String convert(Object obj) {
        if (null == obj) {
            return StringUtils.EMPTY;
        }
        return obj.toString();
    }

    private Map<String, String> get() {
        return result;
    }

    public void save() {
        this.bizLogAsyncSaveService.save(this.result);
    }

}