package com.bxm.localnews.im.controller;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.im.param.ClearMessageParam;
import com.bxm.localnews.im.param.RongCloudParam;
import com.bxm.localnews.im.service.IMService;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "7-02 即时通讯消息相关接口", description = "提供针对即时通讯的相关接口，包括消息删除....")
@RestController
@RequestMapping("message")
public class MessageController extends BaseController {

    private IMService imService;

    @Autowired
    public MessageController(IMService imService) {
        this.imService = imService;
    }

    @ApiOperation(value = "7-02-1 删除消息", notes = "根据客户端触发的时间，删除时间点之前的用户全部消息")
    @PostMapping("remove")
    public Json<Boolean> remove(ClearMessageParam param) {
        imService.remove(param);
        return Json.build(Boolean.TRUE);
    }

    @ApiOperation(value = "7-02-2 [第三方回调]融云即时通讯记录同步", notes = "用户进行即时通讯时，将发送消息同步到服务端", hidden = true)
    @PostMapping("public/callback")
    public void callback(RongCloudParam param) {
        logger.debug("rongcloud callback param :{}", param);

        imService.write(param);
    }
}
