package com.bxm.localnews.im.domain;

import com.bxm.localnews.im.entry.VirtualUserBean;
import com.bxm.localnews.im.param.ClearMessageParam;
import com.bxm.localnews.im.vo.IMMessageBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface MessageMapper {

    /**
     * 保存即时通讯消息
     * @param entity 通讯消息实体
     * @return 插入成功行数
     */
    int insert(IMMessageBean entity);

    /**
     * 清理用户
     * @param param 清理参数
     * @return 影响行数
     */
    int remove(ClearMessageParam param);

    /**
     * 目标用户是否给当前用户回复过消息
     * @param fromUid 发起聊天的用户
     * @param toUid   接收消息的用
     * @return null表示未发送
     */
    Integer hasReply(@Param("fromUid") Long fromUid, @Param("toUid") Long toUid);

    /**
     * 指定时间段内发送了消息的用户数
     * @param startTime 开始时间
     * @param endTime   截止时间
     * @return 发起聊天的用户数
     */
    int sendUserCount(@Param("startTime") Date startTime, @Param("endTime") Date endTime);

    /**
     * 查询重点监控的用户
     * @param startTime 开始时间
     * @param endTime   截止时间
     * @param num       监控数量
     * @return 重点监控用户的ID
     */
    List<Long> queryMonitorUserIds(@Param("startTime") Date startTime,
                                   @Param("endTime") Date endTime,
                                   @Param("num") int num);

    /**
     * 查询马甲号收到的私聊数据
     * @param endTime 查询截止时间
     * @return 马甲号信息
     */
    List<VirtualUserBean> queryVirtualRecive(Date endTime);

    /**
     * 获得聊天
     * @return
     */
    List<String> selectRecentRecord(String chatRoomId);
}
