package com.bxm.localnews.im.domain;

import com.bxm.localnews.im.vo.UserBlockBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface UserBlockMapper {

    /**
     * 新增用户屏蔽记录
     * @param entity 屏蔽信息实体
     * @return 新增结果
     */
    int insert(UserBlockBean entity);

    /**
     * 取消用户屏蔽记录
     * @param userId      用户ID
     * @param blockUserId 被屏蔽的用户ID
     * @return 更新结果
     */
    int cancel(@Param("userId") Long userId, @Param("blockUserId") Long blockUserId);
}
