package com.bxm.localnews.im.bo;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.im.dto.ImRedPacketInfo;
import com.bxm.localnews.im.dto.RedPacketDistributePlanInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

/**
 * @author Gonzo
 * @date 2019-10-30 17:00
 */
@Data
@ApiModel(description = "打开红包参数")
@Builder
public class OpenRedPackageActionParam {

    @ApiModelProperty("打开红包的用户")
    private Long userId;

    @ApiModelProperty("红包信息")
    private ImRedPacketInfo redPacketInfo;

    @ApiModelProperty("基本请求参数")
    private BasicParam basicParam;

    @ApiModelProperty("基本请求参数 areaCode")
    private String areaCode;

    /**
     * 领取完成之后的领取信息，不需要外部传入
     */
    @ApiModelProperty(value = "红包信息", hidden = true)
    RedPacketDistributePlanInfo planInfo;
}
