package com.bxm.localnews.im.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * @author Gonzo
 * @date 2019-10-29 19:44
 */

public class RedPacketRedisCons {

    public static KeyGenerator BASE_KEY = DefaultKeyGenerator.build("im","cache");

    /**
     * 红包基本信息缓存
     */
    public static KeyGenerator RED_PACKET_INFO = BASE_KEY.copy().appendKey("redPacketInfo");

    /**
     * 红包详细信息缓存 （红包详情页面）
     */
    public static KeyGenerator RED_PACKET_DETAIL_INFO = BASE_KEY.copy().appendKey("redPacketDetailInfo");

    /**
     * 定时红包提醒缓存-已失效
     */
    @Deprecated
    public static KeyGenerator TIMING_RED_PACKET_REMINDER_CACHE = BASE_KEY.copy().appendKey("timingRedPacketReminderCache");

    /**
     * 聊天室红包提醒缓存
     */
    public static KeyGenerator ROOM_TIMING_RED_PACKET_REMINDER_CACHE = BASE_KEY.copy().appendKey("roomTimingRedPacketReminderCache");

    /**
     * 红包状态（红包状态页面）
     */
    public static KeyGenerator RED_PACKET_STATUS_INFO = BASE_KEY.copy().appendKey("redPacketStatusInfo");

    /**
     * 红包领取计划缓存
     */
    public static KeyGenerator RED_PACKET_DISTRIBUTE_PLAN = BASE_KEY.copy().appendKey("redPacketDistributePlan");


    /**
     * 红包领取记录
     */
    public static KeyGenerator RED_PACKET_DISTRIBUTE_RECORD = BASE_KEY.copy().appendKey("redPacketDistributeRecord");


    /**
     * 领取红包的分布式锁
     */
    public static KeyGenerator OPEN_RED_PACKET_LOCK = BASE_KEY.copy().appendKey("openRedPacketLock");

    /**
     * 聊天室最近的一个红包计划缓存
     */
    public static KeyGenerator CHAT_ROOM_NEAREST_RED_PACKET_PLAN_INFO = BASE_KEY.copy().appendKey("chatRoomNearestRedPacketPlanInfo");

    /**
     * 该用户在聊天时是否提示过 <引导资料提示> 如：完善 个人资料，让双方相互之间更多了解
     */
    public static KeyGenerator SHOW_INFO_COMPLETE_GUIDE_FLAG = BASE_KEY.copy().appendKey("showInfoCompleteGuideFlag");

}
