package com.bxm.localnews.im.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "群聊信息")
@Data
@Builder
public class GroupInfoDto extends BaseBean {
    @Tolerate
    public  GroupInfoDto(){

    }
    @ApiModelProperty("参与用户头像列表")
    private List<String> joinUserList;

    @ApiModelProperty("参与数量")
    private Integer joinNum;

    @ApiModelProperty("群聊中是否有红包")
    private boolean hasRedPackage;

    @ApiModelProperty("群聊ID")
    private String chatRoomId;

    @ApiModelProperty("人员基数")
    private Integer intervalNumber;

    @ApiModelProperty("提示文案")
    private List<String> copyWriter;

    @ApiModelProperty("聊天室名称")
    private String chatRoomName;

}
