package com.bxm.localnews.im.dto;

import com.bxm.localnews.im.en.RedPacketTypeEn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;


@Data
@Builder
@ApiModel(description = "红包信息")
public class ImRedPacketInfo {

    @ApiModelProperty("红包名称")
    private Long id;

    @ApiModelProperty("红包名称")
    private String name;

    @ApiModelProperty("红包寄语")
    private String remark;

    @ApiModelProperty("红包金额类型 1：现金红包")
    private Byte amountType;

    @ApiModelProperty("红包来源：1：管理后台配置 2：App用户发送")
    private Byte soruce;

    /**
     * @see RedPacketTypeEn
     */
    @ApiModelProperty("红包类型：1：群聊红包 2：个人红包")
    private Byte type;

    @ApiModelProperty("发送用户id")
    private Long sourceUserId;

    @ApiModelProperty("目标id（群聊红包：聊天室id，个人红包：用户id）")
    private String targetId;

    @ApiModelProperty("定时红包计划id")
    private Long timingRedPacketPlanId;

    @ApiModelProperty("领取用户类型：1：邀请好友之后可领取")
    private Byte authType;

    @ApiModelProperty("红包金额 单位元")
    private BigDecimal totalAmount;

    @ApiModelProperty("红包总可领取数")
    private Integer totalNum;

    @ApiModelProperty("红包派发生成策略（群聊红包可用）：1：每个用户可获得0.1~总金额 / 总个数 * 2区间内的金额")
    private Byte redPacketDistributeArithmeticType;

    @ApiModelProperty("红包状态：1：正常 2：已抢完")
    private Byte status;

    @ApiModelProperty("开抢时间（默认为红包创建时间）")
    private Date startTime;

    @ApiModelProperty("抢完时间")
    private Date finishTime;

    @Tolerate
    public ImRedPacketInfo() {

    }

}