package com.bxm.localnews.im.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(description = "目标用户最近动态信息")
public class PersonMessageDTO {

    @ApiModelProperty("用户最近七天发帖信息")
    private ForumPost forumPost;

    @ApiModelProperty("用户最近发布的小纸条记录")
    private List<Note> notes;

    @ApiModelProperty("用户最新的小纸条记录")
    private Note note;

    @Data
    @ApiModel(description = "用户发帖信息")
    public static class ForumPost {

        @ApiModelProperty("帖子id")
        private Long id;

        @ApiModelProperty("帖子标题")
        private String title;

        @ApiModelProperty("图片链接/视频封面图片链接")
        private String imgUrl;

        @ApiModelProperty("帖子文本")
        private String textField;

        @ApiModelProperty("发布时间")
        @JsonFormat(pattern = "yyyy年MM月dd日")
        private Date publishTime;
    }

}
