package com.bxm.localnews.im.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.List;


@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "红包详情")
@Data
@Builder
public class RedPackageDetailDto extends BaseBean {
    @ApiModelProperty("发红包人的头像")
    private String senderImg;

    @ApiModelProperty("发红包人的昵称")
    private String sender;

    @ApiModelProperty("当前用户中奖金额，如果为null则用户未中奖")
    private BigDecimal winnerPaid;

    @ApiModelProperty("红包内容")
    private String content;

    @ApiModelProperty("红包总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("已领取金额")
    private BigDecimal receivedAmount;

    @ApiModelProperty("已领取数量")
    private Integer receivedNum;

    @ApiModelProperty("红包数量")
    private Integer totalNum;

    @ApiModelProperty("领取完毕花费时间，eg：15分钟被抢完")
    private String spendTime;

    @ApiModelProperty("中奖人列表")
    private List<WinnerInfoDto> winners;

    @Tolerate
    public RedPackageDetailDto() {

    }
}
