package com.bxm.localnews.im.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.Date;

@ApiModel(description = "定时红包信息")
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class RedPackageDto extends BaseBean {

    @ApiModelProperty("当前用户是否开启开抢提醒")
    private Boolean enableNotify;

    @ApiModelProperty("红包文案,eg:定时红包")
    private String title;

    @ApiModelProperty(value = "红包内容文案文案 eg：准时开抢")
    private String content;

    @ApiModelProperty(value = "开抢天 eg：今天")
    private String dayStr;

    @ApiModelProperty(value = "开抢时间字符串 eg：16:00")
    private String timeStr;

    @ApiModelProperty(value = "开抢时间")
    private Date startTime;

    @ApiModelProperty("定时红包计划id")
    private Long timingRedPacketPlanId;

    @Tolerate
    public RedPackageDto() {

    }

}
