package com.bxm.localnews.im.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

@ApiModel(description = "红包状态")
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class RedPackageStatusDto extends BaseBean {
    @ApiModelProperty("红包ID")
    private Long id;

    @ApiModelProperty("发红包人的头像")
    private String senderImg;

    @ApiModelProperty("发红包人的昵称")
    private String sender;

    @ApiModelProperty("红包显示文案，eg：恭喜发财、大吉大利")
    private String content;

    @ApiModelProperty("红包领取状态，0: 不可领取 1: 可领取 2：已领取")
    private Byte status;

    @Tolerate
    public RedPackageStatusDto() {

    }
}
