package com.bxm.localnews.im.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

@Data
@Builder
@ApiModel(description = "红包领取计划信息")
public class RedPacketDistributePlanInfo {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("红包id")
    private Long redPacketId;

    @ApiModelProperty("可领取金额")
    private BigDecimal redPacketAmount;

    @ApiModelProperty("领取角标")
    private Integer tIndex;

    @Tolerate
    public RedPacketDistributePlanInfo() {

    }

}