package com.bxm.localnews.im.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;

@Data
@Builder
public class RedPacketDistributeRecordInfo {

    private Long id;

    /**
     * 红包id
     */
    private Long redPacketId;

    /**
     * 红包派发计划id
     */
    private Long redPacketDistributePlanId;

    /**
     * 领取用户id
     */
    private Long userId;


    /**
     * 中奖人昵称
     */
    private String nickName;

    /**
     * 中奖人头像地址
     */
    private String headImg;

    /**
     * 领取时间字符串
     */
    private String receivedTime;

    /**
     * 领取金额
     */
    private BigDecimal amount;

    /**
     * 领取角标
     */
    private Integer redPacketDistributePlanIndex;

    /**
     * 创建时间
     */
    private Date createTime;

    @Tolerate
    public RedPacketDistributeRecordInfo() {

    }

}