package com.bxm.localnews.im.dto;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户会话信息")
@Data
public class SessionInfoDto extends BasicParam {

    @ApiModelProperty("我是否关注他，true表示已关注")
    private Boolean follow = false;

    @ApiModelProperty("他是否关注我，true表示已关注")
    private Boolean followMe = false;

    @ApiModelProperty("是否存在新的对方关注你的消息，存在时显示对应的文案（对方关注了你，我也要关注 | 你们已经互相关注了）")
    private Boolean followMsg = false;

    @ApiModelProperty("是否允许发送消息给对应的用户,false表示无法给对方发送消息")
    private Boolean allowSend = false;

    @ApiModelProperty("是否允许发送媒体文件（图片、视频、语音、帖子），如果为false，在发送媒体文件时提示用户无法发送(具体文案见产品需求)")
    private Boolean allowSendMedia = false;

    @ApiModelProperty("拒收消息的文案，当allowSend为false时，根据需求呈现给用户")
    private String rejectMsg;

    @ApiModelProperty("聊天目标用户信息")
    private UserBean targetUser;

    @ApiModelProperty("当前用户是否显示完善资料引导提示,返回true则显示")
    private Boolean showInfoCompleteGuideFlag = false;

}
