package com.bxm.localnews.im.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

@ApiModel(description = "红包中奖人信息")
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class WinnerInfoDto extends BaseBean {

    @ApiModelProperty("中奖人用户ID")
    private String userId;

    @ApiModelProperty("中奖人昵称")
    private String nickName;

    @ApiModelProperty("中奖人头像地址")
    private String headImg;

    @ApiModelProperty("中奖金额")
    private BigDecimal winnerPaid;

    @ApiModelProperty("是否手气最佳")
    private Boolean luckyGuy;

    @ApiModelProperty("领取时间")
    private String receivedTime;

    @Tolerate
    public WinnerInfoDto() {

    }
}
