package com.bxm.localnews.im.en;

import java.util.Objects;

/**
 * @author Gonzo
 * @date 2019-11-01 15:59
 */
public enum  ChatRoomRedPacketNoticeType {

    /**
     * a、发放前120秒：定时红包将在120秒后到达，请大家做好准备
     *
     * b、发放前60秒：定时红包还有60秒到达，准备好开抢了吗
     *
     * c、发放前10秒：来了来了，红包来了，10秒倒计时，预备备
     *
     * d、发放后60秒：
     * 下一波红包预告--今天17:00
     * 咱们到时候再见哟
     * 小技巧：开启右上角红包内的[开抢提醒]，不错过红包
     */

    /**
     * 提醒类型
     * 1: a, 2: b, 3: c, 4:d
     */

    A((byte) 1, "发放前120秒"),
    B((byte) 2, "发放前60秒"),
    C((byte) 3, "发放前10秒"),
    D((byte) 4, "发放后60秒"),

    ;

    private byte type;

    private String des;

    ChatRoomRedPacketNoticeType(byte type, String des) {
        this.type = type;
        this.des = des;
    }

    public byte getType() {
        return type;
    }

    public String getDes() {
        return des;
    }

    public static ChatRoomRedPacketNoticeType getByType(Byte type) {

        if (Objects.nonNull(type)) {
            for (ChatRoomRedPacketNoticeType value : ChatRoomRedPacketNoticeType.values()) {
                if (value.type == type) {
                    return value;
                }
            }
        }
        return null;
    }
}
