package com.bxm.localnews.im.en;

import java.util.Objects;

/**
 * @author Gonzo
 * @date 2019-10-30 10:27
 */
public enum  RedPacketAmountTypeName {

    CASH((byte) 1, "现金红包"),;

    private byte type;

    private String des;

    RedPacketAmountTypeName(byte type, String des) {
        this.type = type;
        this.des = des;
    }

    public byte getType() {
        return type;
    }

    public String getDes() {
        return des;
    }

    public static RedPacketAmountTypeName getByType(Byte type) {

        if (Objects.nonNull(type)) {
            for (RedPacketAmountTypeName value : RedPacketAmountTypeName.values()) {
                if (value.type == type) {
                    return value;
                }
            }
        }
        return null;
    }

}
