package com.bxm.localnews.im.en;

import java.util.Objects;

/**
 * 红包领取计划生成策略类型
 * @author Gonzo
 * @date 2019-10-29 19:10
 */
public enum  RedPacketDistributeArithmeticTypeEn {

    MAX_DOUBLE_AVER((byte) 1, "每个用户可获得0.1~总金额 / 总个数 * 2区间内的金额"),
    MAX_DOUBLE_AVER_2((byte) 2, "每个用户可获得0.1~总金额 / 总个数 * 2区间内的金额"),
    ;

    private byte type;

    private String des;

    RedPacketDistributeArithmeticTypeEn(byte type, String des) {
        this.type = type;
        this.des = des;
    }

    public byte getType() {
        return type;
    }

    public String getDes() {
        return des;
    }

    public static RedPacketDistributeArithmeticTypeEn getByType(Byte type) {

        if (Objects.nonNull(type)) {
            for (RedPacketDistributeArithmeticTypeEn value : RedPacketDistributeArithmeticTypeEn.values()) {
                if (value.type == type) {
                    return value;
                }
            }
        }
        return null;
    }

}
