package com.bxm.localnews.im.en;

import java.util.Objects;

/**
 * 红包类型
 * @author Gonzo
 * @date 2019-10-29 18:43
 */
public enum  RedPacketTypeEn {

    CHAT_ROOM((byte) 1, "群聊红包"),

    PERSONAL((byte) 2, "个人红包");

    private byte type;

    private String des;

    RedPacketTypeEn(byte type, String des) {
        this.type = type;
        this.des = des;
    }

    public byte getType() {
        return type;
    }

    public String getDes() {
        return des;
    }

    public static RedPacketTypeEn getByType(Byte type) {

        if (Objects.nonNull(type)) {
            for (RedPacketTypeEn value : RedPacketTypeEn.values()) {
                if (value.type == type) {
                    return value;
                }
            }
        }
        return null;
    }

}
