package com.bxm.localnews.im.entry;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;

@Data
@Builder
public class ImRedPacket {
    private Long id;

    /**
     * 红包名称
     */
    private String name;

    /**
     * 红包寄语
     */
    private String remark;

    /**
     * 红包金额类型 1：现金红包
     */
    private Byte amountType;

    /**
     * 红包来源：1：管理后台配置 2：App用户发送
     */
    private Byte source;

    /**
     * 红包类型：1：群聊红包 2：个人红包
     */
    private Byte type;

    /**
     * 发送用户id
     */
    private Long sourceUserId;

    /**
     * 目标id（群聊红包：聊天室id，个人红包：用户id）
     */
    private String targetId;

    /**
     * 定时红包计划id
     */
    private Long timingRedPacketPlanId;

    /**
     * 领取用户类型：1：邀请好友之后可领取
     */
    private Byte authType;

    /**
     * 红包金额 单位元
     */
    private BigDecimal totalAmount;

    /**
     * 红包总可领取数
     */
    private Integer totalNum;

    /**
     * 开抢时间（默认为红包创建时间）
     */
    private Date startTime;

    /**
     * 抢完时间
     */
    private Date finishTime;

    /**
     * 红包状态：1：正常 2：已抢完
     */
    private Byte status;

    /**
     * 删除状态：0：未删除 1：已删除
     */
    private Byte deleteFlag;

    /**
     * 删除时间
     */
    private Date deleteTime;

    /**
     * 最后修改时间
     */
    private Date modifyTime;

    /**
     * 创建时间
     */
    private Date createTime;

    @Tolerate
    public ImRedPacket() {

    }
}