package com.bxm.localnews.im.entry;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;

@Data
@Builder
public class ImRedPacketDistributePlan {
    private Long id;

    /**
     * 红包id
     */
    private Long redPacketId;

    /**
     * 可领取金额
     */
    private BigDecimal redPacketAmount;

    /**
     * 领取角标
     */
    private Integer tIndex;

    /**
     * 状态：1：正常
     */
    private Byte status;

    /**
     * 删除状态：0：未删除 1：已删除
     */
    private Byte deleteFlag;

    /**
     * 删除时间
     */
    private Date deleteTime;

    /**
     * 最后修改时间
     */
    private Date modifyTime;

    /**
     * 创建时间
     */
    private Date createTime;

    @Tolerate
    public ImRedPacketDistributePlan() {

    }
}